/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.getui.gtc.base.db.AbstractDb;

public abstract class AbstractTable {
    private AbstractDb db;

    public abstract String getTableName();

    public abstract String createSql();

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
    }

    protected void initCache() {
    }

    public void onDowngradle(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
    }

    final void setDb(AbstractDb abstractDb) {
        this.db = abstractDb;
    }

    public final SQLiteDatabase getWritableDatabase() {
        if (this.db == null) {
            throw new RuntimeException("table " + this.getTableName() + " has not been added to a db");
        }
        return this.db.getHelper().getWritableDatabase();
    }

    public final SQLiteDatabase getReadableDatabase() {
        if (this.db == null) {
            throw new RuntimeException("table " + this.getTableName() + " has not been added to a db");
        }
        return this.db.getHelper().getReadableDatabase();
    }

    public void execSql(String string) {
        this.getWritableDatabase().execSQL(string);
    }

    public long insert(ContentValues contentValues) {
        return this.getWritableDatabase().insert(this.getTableName(), null, contentValues);
    }

    public long replace(String string, ContentValues contentValues) {
        return this.getWritableDatabase().replace(this.getTableName(), string, contentValues);
    }

    public int update(ContentValues contentValues, String string, String[] stringArray) {
        return this.getWritableDatabase().update(this.getTableName(), contentValues, string, stringArray);
    }

    public Cursor query(String[] stringArray, String string, String[] stringArray2, String string2, String string3, String string4) {
        return this.getReadableDatabase().query(this.getTableName(), stringArray, string, stringArray2, string2, string3, string4);
    }

    public Cursor query(String[] stringArray, String string, String[] stringArray2) {
        return this.getReadableDatabase().query(this.getTableName(), stringArray, string, stringArray2, null, null, null);
    }

    public Cursor query(String string) {
        return this.getReadableDatabase().rawQuery(string, null);
    }

    public int delete(String string, String[] stringArray) {
        return this.getWritableDatabase().delete(this.getTableName(), string, stringArray);
    }
}

