/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.Request;
import com.getui.gtc.base.http.ResponseBody;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Response
implements Closeable {
    final Request request;
    final int code;
    final String message;
    final Map<String, List<String>> headers;
    final ResponseBody body;

    Response(Builder builder) {
        this.request = builder.request;
        this.code = builder.code;
        this.message = builder.message;
        this.headers = new HashMap<String, List<String>>(builder.headers);
        this.body = builder.body;
    }

    public int code() {
        return this.code;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Deprecated
    public byte[] getBody() {
        try {
            return this.body.bytes();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ResponseBody body() {
        return this.body;
    }

    public Request request() {
        return this.request;
    }

    public String message() {
        return this.message;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String header(String iterator) {
        if ((iterator = this.headers.get(iterator)) == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuilder.append(string);
            stringBuilder.append("; ");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.delete(stringBuilder2.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Override
    public void close() {
        if (this.body == null) {
            throw new IllegalStateException("response is not eligible for a body and must not be closed");
        }
        this.body.close();
    }

    public static class Builder {
        Request request;
        int code = -1;
        String message;
        Map<String, List<String>> headers;
        ResponseBody body;

        public Builder() {
            this.headers = new HashMap<String, List<String>>();
        }

        Builder(Response response) {
            this.request = response.request;
            this.code = response.code;
            this.message = response.message;
            this.headers = new HashMap<String, List<String>>(response.headers);
            this.body = response.body;
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder code(int n2) {
            this.code = n2;
            return this;
        }

        public Builder message(String string) {
            this.message = string;
            return this;
        }

        public Builder setHeader(String string, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.headers.put(string, arrayList);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            List<String> list = this.headers.get(string);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(string2);
            this.headers.put(string, list);
            return this;
        }

        public Builder removeHeader(String string) {
            this.headers.remove(string);
            return this;
        }

        public Builder headers(Map<String, List<String>> map) {
            this.headers = new HashMap<String, List<String>>(map);
            return this;
        }

        public Builder body(ResponseBody responseBody) {
            this.body = responseBody;
            return this;
        }

        public Response build() {
            if (this.request == null) {
                throw new IllegalStateException("request == null");
            }
            if (this.code < 0) {
                throw new IllegalStateException("code < 0: " + this.code);
            }
            if (this.message == null) {
                throw new IllegalStateException("message == null");
            }
            return new Response(this);
        }
    }
}

