/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http.crypt;

import android.util.Base64;
import com.getui.gtc.base.crypt.CryptTools;
import com.getui.gtc.base.http.Interceptor;
import com.getui.gtc.base.http.Request;
import com.getui.gtc.base.http.RequestBody;
import com.getui.gtc.base.http.Response;
import com.getui.gtc.base.http.ResponseBody;
import com.getui.gtc.base.http.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class GtRASCryptoInterceptor
implements Interceptor {
    private final String publicKeyStr;
    private final String keyId;

    public GtRASCryptoInterceptor(String string, String string2) {
        this.keyId = string;
        this.publicKeyStr = string2;
    }

    @Override
    public Response intercept(Interceptor.Chain object) throws IOException {
        Object object2 = object.request();
        List<String> list = ((Request)object2).newBuilder();
        Object object3 = ((Request)object2).body();
        if (object3 == null) {
            throw new RuntimeException("GtRASCryptoInterceptor Error: request body is null");
        }
        Object object4 = new ByteArrayOutputStream();
        Object object5 = new GZIPOutputStream((OutputStream)object4);
        ((RequestBody)object3).writeTo((OutputStream)object5);
        ((GZIPOutputStream)object5).finish();
        Util.closeQuietly((Closeable)object5);
        Util.closeQuietly((Closeable)object4);
        try {
            ((Request.Builder)((Object)list)).addHeader("GT_C_T", "1").addHeader("GT_C_K", this.keyId);
            object5 = String.valueOf(System.currentTimeMillis());
            ((Request.Builder)((Object)list)).addHeader("GT_T", (String)object5);
            Object object6 = new SecureRandom();
            byte[] byArray = new byte[16];
            ((SecureRandom)object6).nextBytes(byArray);
            object6 = CryptTools.parsePublicKey("RSA", this.publicKeyStr);
            SecretKey secretKey = CryptTools.generateKey("AES", 128);
            object6 = CryptTools.encrypt("RSA/NONE/OAEPWithSHA1AndMGF1Padding", (PublicKey)object6, secretKey.getEncoded());
            byte[] byArray2 = new byte[16 + ((Object)object6).length];
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            System.arraycopy(object6, 0, byArray2, 16, ((Object)object6).length);
            object6 = Base64.encodeToString((byte[])byArray2, (int)2);
            ((Request.Builder)((Object)list)).addHeader("GT_C_V", (String)object6);
            object5 = ((String)object5).getBytes();
            object4 = ((ByteArrayOutputStream)object4).toByteArray();
            object6 = new byte[((Object)object5).length + ((Object)object4).length];
            System.arraycopy(object5, 0, object6, 0, ((Object)object5).length);
            System.arraycopy(object4, 0, object6, ((Object)object5).length, ((Object)object4).length);
            object5 = Base64.encodeToString((byte[])CryptTools.digest("SHA1", (byte[])object6), (int)2);
            ((Request.Builder)((Object)list)).addHeader("GT_C_S", (String)object5);
            object5 = CryptTools.digest("MD5", ((String)object5).getBytes());
            object5 = new IvParameterSpec((byte[])object5);
            object4 = CryptTools.encrypt("AES/CFB/NoPadding", secretKey, (IvParameterSpec)object5, (byte[])object4);
            ((Request.Builder)((Object)list)).body(RequestBody.create(((RequestBody)object3).contentType(), (byte[])object4));
            object = object.proceed(((Request.Builder)((Object)list)).build());
            if (((Response)object).code() != 200) {
                return object;
            }
            object2 = ((Response)object).newBuilder().request((Request)object2);
            list = ((Response)object).getHeaders().get("GT_ERR");
            if (list == null || list.size() <= 0 || !"0".equals(list.get(0))) {
                if (list != null) {
                    throw new SecurityException("GT_ERR header is " + (String)list.get(0));
                }
                throw new SecurityException("GT_ERR header not found");
            }
            ((Response.Builder)object2).removeHeader("GT_ERR");
            list = ((Response)object).getHeaders().get("GT_T");
            if (list == null || list.size() <= 0) {
                throw new SecurityException("GT_T header not found");
            }
            list = (List<String>)list.get(0).getBytes();
            object3 = new IvParameterSpec(CryptTools.digest("MD5", (byte[])list));
            ((Response.Builder)object2).removeHeader("GT_T");
            object4 = ((Response)object).getHeaders().get("GT_C_S");
            if (object4 == null || object4.size() <= 0) {
                throw new SecurityException("GT_C_S header not found");
            }
            object4 = Base64.decode((String)object4.get(0), (int)2);
            object5 = ((Response)object).body().bytes();
            byte[] byArray3 = CryptTools.decrypt("AES/CFB/NoPadding", secretKey, (IvParameterSpec)object3, (byte[])object5);
            object3 = byArray3;
            object5 = new byte[byArray3.length + ((Object)list).length];
            System.arraycopy(list, 0, object5, 0, ((Object)list).length);
            System.arraycopy(object3, 0, object5, ((Object)list).length, ((Object)object3).length);
            if (!Arrays.equals(CryptTools.digest("SHA1", (byte[])object5), (byte[])object4)) {
                throw new SecurityException("response body sign check failed");
            }
            ((Response.Builder)object2).removeHeader("GT_C_S");
            ((Response.Builder)object2).body(ResponseBody.create(((Response)object).body().contentType(), (byte[])object3));
            return ((Response.Builder)object2).build();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("GtRASCryptoInterceptor Error", generalSecurityException);
        }
    }
}

