/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.dim;

import android.os.Parcel;
import android.os.Parcelable;
import com.getui.gtc.dim.AllowSysCall;
import com.getui.gtc.dim.Caller;

public class DimRequest
implements Parcelable {
    private String key;
    private long ramCacheValidTime;
    private long storageCacheValidTime;
    private AllowSysCall allowSysCall;
    private boolean useExpiredCacheForReserve;
    private Caller caller;
    private boolean skipCache;
    public static final Parcelable.Creator<DimRequest> CREATOR = new Parcelable.Creator<DimRequest>(){

        public final DimRequest createFromParcel(Parcel parcel) {
            return new DimRequest(parcel);
        }

        public final DimRequest[] newArray(int n2) {
            return new DimRequest[n2];
        }
    };

    private DimRequest() {
    }

    private DimRequest(Builder builder) {
        this.key = builder.key;
        this.ramCacheValidTime = builder.ramCacheValidTime;
        this.storageCacheValidTime = builder.storageCacheValidTime;
        this.allowSysCall = builder.allowSysCall;
        this.useExpiredCacheForReserve = builder.useExpiredCacheForReserve;
        this.caller = builder.caller;
        this.skipCache = builder.skipCache;
    }

    protected DimRequest(Parcel parcel) {
        this.key = parcel.readString();
        this.ramCacheValidTime = parcel.readLong();
        this.storageCacheValidTime = parcel.readLong();
        this.allowSysCall = AllowSysCall.valueOf(parcel.readInt());
        this.useExpiredCacheForReserve = parcel.readByte() != 0;
        int n2 = parcel.readInt();
        if (n2 >= 0) {
            this.caller = Caller.values()[n2];
        }
        this.skipCache = parcel.readByte() != 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.key);
        parcel.writeLong(this.ramCacheValidTime);
        parcel.writeLong(this.storageCacheValidTime);
        parcel.writeInt(this.allowSysCall.getValue());
        parcel.writeByte((byte)(this.useExpiredCacheForReserve ? 1 : 0));
        parcel.writeInt(this.caller != null ? this.caller.ordinal() : -1);
        parcel.writeByte((byte)(this.skipCache ? 1 : 0));
    }

    public int describeContents() {
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public Caller getCaller() {
        return this.caller;
    }

    public boolean isSkipCache() {
        return this.skipCache;
    }

    @Deprecated
    public long getRamCacheValidTime() {
        return this.ramCacheValidTime;
    }

    @Deprecated
    public void setRamCacheValidTime(long l2) {
        this.ramCacheValidTime = l2;
    }

    @Deprecated
    public long getStorageCacheValidTime() {
        return this.storageCacheValidTime;
    }

    @Deprecated
    public void setStorageCacheValidTime(long l2) {
        this.storageCacheValidTime = l2;
    }

    @Deprecated
    public AllowSysCall getAllowSysCall() {
        return this.allowSysCall;
    }

    @Deprecated
    public void setAllowSysCall(AllowSysCall allowSysCall) {
        this.allowSysCall = allowSysCall;
    }

    @Deprecated
    public boolean isUseExpiredCacheForReserve() {
        return this.useExpiredCacheForReserve;
    }

    @Deprecated
    public void setUseExpiredCacheForReserve(boolean bl) {
        this.useExpiredCacheForReserve = bl;
    }

    public String toString() {
        return "DimRequest{key='" + this.key + '\'' + ", ramCacheValidTime=" + this.ramCacheValidTime + ", storageCacheValidTime=" + this.storageCacheValidTime + ", allowSysCall=" + (Object)((Object)this.allowSysCall) + ", useExpiredCacheForReserve=" + this.useExpiredCacheForReserve + ", caller=" + (Object)((Object)this.caller) + ", skipCache=" + this.skipCache + '}';
    }

    public static class Builder {
        private String key;
        private long ramCacheValidTime = 60000L;
        private long storageCacheValidTime = 60000L;
        private AllowSysCall allowSysCall = AllowSysCall.ALL_ALLOW;
        private boolean useExpiredCacheForReserve = false;
        private Caller caller;
        private boolean skipCache = false;

        public Builder() {
        }

        public Builder(DimRequest dimRequest) {
            this.key = dimRequest.key;
            this.ramCacheValidTime = dimRequest.ramCacheValidTime;
            this.storageCacheValidTime = dimRequest.storageCacheValidTime;
            this.allowSysCall = dimRequest.allowSysCall;
            this.useExpiredCacheForReserve = dimRequest.useExpiredCacheForReserve;
            this.caller = dimRequest.caller;
            this.skipCache = dimRequest.skipCache;
        }

        public Builder key(String string) {
            this.key = string;
            return this;
        }

        public Builder skipCache(boolean bl) {
            this.skipCache = bl;
            return this;
        }

        public Builder caller(Caller caller) {
            this.caller = caller;
            return this;
        }

        @Deprecated
        public Builder ramCacheValidTime(long l2) {
            this.ramCacheValidTime = l2;
            return this;
        }

        @Deprecated
        public Builder storageCacheValidTime(long l2) {
            this.storageCacheValidTime = l2;
            return this;
        }

        @Deprecated
        public Builder allowSysCall(boolean bl) {
            this.allowSysCall = bl ? AllowSysCall.ALL_ALLOW : AllowSysCall.NOT_ALLOW;
            return this;
        }

        @Deprecated
        public Builder allowSysCall(AllowSysCall allowSysCall) {
            this.allowSysCall = allowSysCall;
            return this;
        }

        @Deprecated
        public Builder useExpiredCacheForReserve(boolean bl) {
            this.useExpiredCacheForReserve = bl;
            return this;
        }

        public DimRequest build() {
            return new DimRequest(this);
        }
    }
}

