/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.dim;

import android.util.Base64;
import com.getui.gtc.dim.Caller;
import com.getui.gtc.dim.DimCallback;
import com.getui.gtc.dim.e.b;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class DimSource {
    private static final HashMap<Caller, DimSource> SOURCE_MAP = new HashMap(4);

    public abstract <P, V> V get(P var1, DimCallback<P, V> var2);

    public int getFlags() {
        return 0;
    }

    public <T> T invoke(Object object, Method method, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
        throw new UnsupportedOperationException("DimSource's child " + this.getClass() + " required method invoke was not overridden");
    }

    public static synchronized DimSource of(Caller caller) {
        if (caller != null && caller != Caller.UNKNOWN) {
            if (SOURCE_MAP.containsKey((Object)caller)) {
                return SOURCE_MAP.get((Object)caller);
            }
            Object object = null;
            if (caller == Caller.PUSH) {
                object = "Y29tLmlnZXhpbi5wdXNo";
            } else if (caller == Caller.IDO) {
                object = "Y29tLmdldHVpLmdz";
            } else if (caller == Caller.GY) {
                object = "Y29tLmcuZ3lzZGs=";
            } else if (caller == Caller.WUS) {
                object = "Y29tLnNkay5wbHVz";
            } else if (caller == Caller.ONEID) {
                object = "Y29tLmdldHVpLm9uZWlk";
            }
            object = DimSource.of((String)object);
            SOURCE_MAP.put(caller, (DimSource)object);
            return object;
        }
        return null;
    }

    private static DimSource of(String string) {
        try {
            string = new String(Base64.decode((String)string, (int)0));
            return (DimSource)Class.forName(string + ".SdkSource").getDeclaredField("INSTANCE").get(null);
        }
        catch (Throwable throwable) {
            b.b(throwable);
            return null;
        }
    }

    public static class HFSource
    extends DimSource {
        public static final HFSource INSTANCE = new HFSource();

        private HFSource() {
        }

        @Override
        public <P, V> V get(P p2, DimCallback<P, V> dimCallback) {
            b.a("dim sys call from hf");
            return dimCallback.get(p2);
        }
    }
}

