/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.dim.bean;

import android.location.Location;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.getui.gtc.dim.DimSource;
import com.getui.gtc.dim.e.b;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class GtLocation
implements Parcelable {
    private boolean hasAccuracy;
    private long time;
    private String provider;
    private double longitude;
    private double latitude;
    private long elapsedRealtimeNanos;
    private double altitude;
    private float accuracy;
    public static final Parcelable.Creator<GtLocation> CREATOR = new Parcelable.Creator<GtLocation>(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new GtLocation(parcel);
        }
    };

    private GtLocation() {
    }

    @Deprecated
    public GtLocation(Location location) {
        this.hasAccuracy = location.hasAccuracy();
        this.accuracy = location.getAccuracy();
        this.time = location.getTime();
        this.provider = location.getProvider();
        this.longitude = location.getLongitude();
        this.latitude = location.getLatitude();
        if (Build.VERSION.SDK_INT >= 17) {
            this.elapsedRealtimeNanos = location.getElapsedRealtimeNanos();
        }
        this.altitude = location.getAltitude();
    }

    public GtLocation(Location location, DimSource dimSource) {
        this.hasAccuracy = location.hasAccuracy();
        this.accuracy = location.getAccuracy();
        this.time = location.getTime();
        this.provider = location.getProvider();
        if (Build.VERSION.SDK_INT >= 17) {
            this.elapsedRealtimeNanos = location.getElapsedRealtimeNanos();
        }
        if (dimSource == null) {
            this.longitude = location.getLongitude();
            this.latitude = location.getLatitude();
            this.altitude = location.getAltitude();
            return;
        }
        try {
            Method method = Location.class.getMethod("getLongitude", new Class[0]);
            this.longitude = (Double)dimSource.invoke(location, method, new Object[0]);
            method = Location.class.getMethod("getLatitude", new Class[0]);
            this.latitude = (Double)dimSource.invoke(location, method, new Object[0]);
            method = Location.class.getMethod("getAltitude", new Class[0]);
            this.altitude = (Double)dimSource.invoke(location, method, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            b.a(throwable);
            return;
        }
    }

    protected GtLocation(Parcel parcel) {
        this.hasAccuracy = parcel.readByte() != 0;
        this.time = parcel.readLong();
        this.provider = parcel.readString();
        this.longitude = parcel.readDouble();
        this.latitude = parcel.readDouble();
        this.elapsedRealtimeNanos = parcel.readLong();
        this.altitude = parcel.readDouble();
        this.accuracy = parcel.readFloat();
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeByte((byte)(this.hasAccuracy ? 1 : 0));
        parcel.writeLong(this.time);
        parcel.writeString(this.provider);
        parcel.writeDouble(this.longitude);
        parcel.writeDouble(this.latitude);
        parcel.writeLong(this.elapsedRealtimeNanos);
        parcel.writeDouble(this.altitude);
        parcel.writeFloat(this.accuracy);
    }

    public int describeContents() {
        return 0;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public boolean hasAccuracy() {
        return this.hasAccuracy;
    }

    public long getTime() {
        return this.time;
    }

    public String getProvider() {
        return this.provider;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public long getElapsedRealtimeNanos() {
        return this.elapsedRealtimeNanos;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public float distanceTo(double d2, double d3) {
        double d4 = this.latitude;
        double d5 = this.longitude;
        double d6 = d2 * (Math.PI / 180);
        double d7 = d3 * (Math.PI / 180) - (d5 *= Math.PI / 180);
        double d8 = 0.0;
        double d9 = Math.atan(0.996647189328169 * Math.tan(d4 *= Math.PI / 180));
        double d10 = Math.atan(0.996647189328169 * Math.tan(d6));
        double d11 = Math.cos(d9);
        double d12 = Math.cos(d10);
        double d13 = Math.sin(d9);
        double d14 = Math.sin(d10);
        double d15 = d11 * d12;
        double d16 = d13 * d14;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = d7;
        for (int i2 = 0; i2 < 20; ++i2) {
            double d20;
            double d21 = d19;
            double d22 = Math.cos(d19);
            double d23 = Math.sin(d19);
            double d24 = d12 * d23;
            double d25 = d11 * d14 - d13 * d12 * d22;
            double d26 = d24;
            double d27 = d25;
            double d28 = Math.sqrt(d26 * d26 + d27 * d27);
            double d29 = d16 + d15 * d22;
            d17 = Math.atan2(d28, d29);
            double d30 = d20 = d28 == 0.0 ? 0.0 : d15 * d23 / d28;
            double d31 = 1.0 - d30 * d30;
            double d32 = d31 == 0.0 ? 0.0 : d29 - 2.0 * d16 / d31;
            double d33 = d31 * 0.006739496756586903;
            d8 = 1.0 + d33 / 16384.0 * (4096.0 + d33 * (-768.0 + d33 * (320.0 - 175.0 * d33)));
            double d34 = d33 / 1024.0 * (256.0 + d33 * (-128.0 + d33 * (74.0 - 47.0 * d33)));
            double d35 = 2.0955066698943685E-4 * d31 * (4.0 + 0.0033528106718309896 * (4.0 - 3.0 * d31));
            double d36 = d32;
            double d37 = d36 * d36;
            d18 = d34 * d28 * (d32 + d34 / 4.0 * (d29 * (-1.0 + 2.0 * d37) - d34 / 6.0 * d32 * (-3.0 + 4.0 * d28 * d28) * (-3.0 + 4.0 * d37)));
            d19 = d7 + (1.0 - d35) * 0.0033528106718309896 * d20 * (d17 + d35 * d28 * (d32 + d35 * d29 * (-1.0 + 2.0 * d32 * d32)));
            if (Math.abs((d19 - d21) / d19) < 1.0E-12) break;
        }
        return (float)(6356752.3142 * d8 * (d17 - d18));
    }

    public String toJsonString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("hasAccuracy", this.hasAccuracy);
            jSONObject.put("time", this.time);
            jSONObject.put("provider", (Object)this.provider);
            jSONObject.put("longitude", this.longitude);
            jSONObject.put("latitude", this.latitude);
            jSONObject.put("elapsedRealtimeNanos", this.elapsedRealtimeNanos);
            jSONObject.put("altitude", this.altitude);
            jSONObject.put("accuracy", (Object)String.valueOf(this.accuracy));
            return jSONObject.toString();
        }
        catch (Throwable throwable) {
            b.b(throwable);
            return null;
        }
    }

    public static GtLocation parseJson(String string) {
        block4: {
            try {
                if (string == null) break block4;
                string = new JSONObject(string);
                GtLocation gtLocation = new GtLocation();
                new GtLocation().hasAccuracy = string.optBoolean("hasAccuracy", false);
                gtLocation.time = string.optLong("time", 0L);
                gtLocation.provider = string.optString("provider", "");
                gtLocation.longitude = string.optDouble("longitude", 0.0);
                gtLocation.latitude = string.optDouble("latitude", 0.0);
                gtLocation.elapsedRealtimeNanos = string.optLong("elapsedRealtimeNanos", 0L);
                gtLocation.altitude = string.optDouble("altitude", 0.0);
                try {
                    gtLocation.accuracy = Float.parseFloat(string.optString("accuracy", "0"));
                }
                catch (Throwable throwable) {}
                return gtLocation;
            }
            catch (JSONException jSONException) {
                b.b(jSONException);
            }
        }
        return null;
    }
}

